// Copyright 1994 by Jon Dart.
#ifndef __CHESSIO_H__
#define __CHESSIO_H__

#include "board.h"
#include "epdrec.h"
#include <fstream.h>

class Log;


class ChessIO
{
public:

    /**** PGN file support ****/
    
    // scan a PGN file, fill "contents" with strings.  Each string contains
    // a descriptive 1-line header followed by a tab and the file offset
    // of the game in decimal digits. 
    static BOOL scan_pgn(ifstream &ifs, CStringList &contents);

    // read in a game in PGN format.
    static BOOL load_fen(ifstream &ifs, Board &board);
#ifndef _CONSOLE
    static BOOL load_pgn(ifstream &ifs, Log &log, DWORD offset = 0L);
#endif
    static BOOL store_pgn(ofstream &ofs, Log &log,
                          const ColorType computer_side,
                          LPCSTR eco = NULL);
    static BOOL store_fen(ofstream &ofs, const Board &board);

    // read a PGN game header from the file.
    static void collect_headers(ifstream &game_file, CPtrArray *&hdrs, long &first);

    enum Token { Number, GameMove, Result, Comment, Unknown, Ignore, Eof };
    // read the next token from the "body" of a PGN game.
    static Token get_next_token(ifstream &game_file, char *buf, int limit);

#ifdef _WINDOWS
    /**** EPD file support ****/
    
    static EPD_Record * read_epd_record(ifstream &ifs, Board &board);
    static void execute_epd_record(EPD_Record *rec, Board &board);
    static void annotate_epd_record(EPD_Record *rec, Board &board,
                                    ofstream &outfile);
#endif    
    
    /**** FEN file support ****/
    
    static BOOL read_fen(Board &board, char *buf);
    static void write_fen(const Board &board, char *buf, BOOL addMoveInfo);
};

#endif
